{ ------------------------------------------------------------------------ }
{  @@ Source Documentation                           *** TP6 Version ***   }
{                                                                          }
{  Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.   }
{                                                                          }
{   TITLE       : MIDIIN.PAS                                               }
{                                                                          }
{   DESCRIPTION :                                                          }
{       This program demostrates how to use the SBK MIDI interface         }
{       functions to read in the MIDI code through DSP and display         }
{       it on screen. The user can terminate the process by pressing       }
{       ESC key.                                                           }
{                                                                          }
{       The program checks BLASTER environment for the Card settings.      }
{       It also performs test base on BLASTER environment settings to      }
{       ensure they are tally with the hardware settings on the Card.      }
{                                                                          }
{ ------------------------------------------------------------------------ }

program midiin;

{ Include the SBC Unit, and any other units needed }
uses sbc_tp6, dos, crt;

type
    TwoChar = array[0..1] of char;
    TwoCharPtr = ^TwoChar;

var
    HexStr : TwoChar;


{ ------------------------------------------------------------------------ }
{  @@ Usage                                                                }
{                                                                          }
{   function IntToHexStr(x : byte) : TwoCharPtr                            }
{                                                                          }
{   DESCRIPTION:                                                           }
{       Convert byte to hex array.                                         }
{                                                                          }
{   ENTRY:                                                                 }
{       x :- byte to be converted.                                         }
{                                                                          }
{   EXIT:                                                                  }
{       pointer to the converted hex array.                                }
{                                                                          }
{ ------------------------------------------------------------------------ }

{ Function to convert byte to hex array }
function IntToHexStr(x : byte) : TwoCharPtr;
var
    tmp, l : byte;

begin

    for l := 1 downto 0 do begin
        tmp := x and $0f;

        if (tmp >= 10) and (tmp <= 15) then
            HexStr[l] := CHR(tmp+$41-10)
        else
            HexStr[l] := CHR(tmp+$30);

        x := x shr 4;
    end;

    IntToHexStr := @HexStr;

end;


{ ------------------------------------------------------------------------ }

{ main function }
var
    midi_code, time_stamp : longint;
    midi_byte : byte;
    stop_flag : boolean;

begin

    if GetEnvSetting = 0 then begin

        if boolean( sbc_check_card and $0004 ) then begin

            if boolean(sbc_test_int) then begin

                { Start input }
                sbmidi_start_input;

                stop_flag := False;

                repeat
                    { Check for ESC key }
                    if KeyPressed then
                        if ReadKey = #27 then
                            stop_flag := True;

                    { Read the MIDI input from buffer }
                    midi_code := sbmidi_get_input;

                    if ( midi_code <> longint(0) ) then begin
                        midi_byte := byte(midi_code and $000000ff);
                        time_stamp := midi_code shr 8;
                    
                        writeln('MIDI Byte : ',(IntToHexStr(midi_byte))^:2,
                                ' hex    Time Stamp : ',time_stamp:8,' msec');
                    end;
                until stop_flag;


                { Stop input }
                sbmidi_stop_input;


                { read the remaining codes in the buffer }
                repeat
                    midi_code := sbmidi_get_input;

                    if ( midi_code <> longint(0) ) then begin
                        midi_byte := byte(midi_code and $000000ff);
                        time_stamp := midi_code shr 8;

                        writeln('MIDI Byte : ',(IntToHexStr(midi_byte))^:2,
                                ' hex    Time Stamp : ',time_stamp:8,' msec');
                    end;
                until not boolean(midi_code);

            end
            else
                writeln('Error on interrupt.');
        end
        else
            writeln('Sound Blaster card not found or wrong I/O setting.');
    end
    else
        writeln('BLASTER environment variable not set or incomplete or invalid.');
end.
